<?php
/**
 * Fired when the plugin is uninstalled.
 *
 * @link       https://build.fuly.io
 * @since      1.0.0
 *
 * @package    Buildfuly
 */

// If uninstall not called from WordPress, then exit.
if ( ! defined( 'WP_UNINSTALL_PLUGIN' ) ) {
	die;
}

// Delete plugin options
delete_option( 'buildfuly_license_key' );
delete_option( 'buildfuly_license_status' );
delete_option( 'buildfuly_license_data' );
delete_option( 'buildfuly_user_tier' );
delete_option( 'buildfuly_api_key' );
delete_option( 'buildfuly_generation_mode' );
delete_option( 'buildfuly_generation_instructions' );
delete_option( 'buildfuly_cta_buttons' );
delete_option( 'buildfuly_contact_form_embed' );
delete_option( 'buildfuly_onboarding_completed' );
delete_option( 'buildfuly_business_name' );
delete_option( 'buildfuly_business_description' );
delete_option( 'buildfuly_review_platform' );
delete_option( 'buildfuly_review_link' );
delete_option( 'buildfuly_free_license' );

// Drop custom database tables if they exist
global $wpdb;
$wpdb->query( "DROP TABLE IF EXISTS {$wpdb->prefix}buildfuly_pages" ); // phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery, WordPress.DB.DirectDatabaseQuery.NoCaching, WordPress.DB.DirectDatabaseQuery.SchemaChange -- Uninstall cleanup, must drop tables
$wpdb->query( "DROP TABLE IF EXISTS {$wpdb->prefix}buildfuly_page_styles" ); // phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery, WordPress.DB.DirectDatabaseQuery.NoCaching, WordPress.DB.DirectDatabaseQuery.SchemaChange -- Uninstall cleanup, must drop tables
$wpdb->query( "DROP TABLE IF EXISTS {$wpdb->prefix}buildfuly_history" ); // phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery, WordPress.DB.DirectDatabaseQuery.NoCaching, WordPress.DB.DirectDatabaseQuery.SchemaChange -- Uninstall cleanup, must drop tables
$wpdb->query( "DROP TABLE IF EXISTS {$wpdb->prefix}buildfuly_seo_metadata" ); // phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery, WordPress.DB.DirectDatabaseQuery.NoCaching, WordPress.DB.DirectDatabaseQuery.SchemaChange -- Uninstall cleanup, must drop tables

// Clear any cached data
wp_cache_flush();
