<?php

/**
 * Fired during plugin deactivation
 *
 * @link       https://build.fuly.io
 * @since      1.0.0
 *
 * @package    Buildfuly
 * @subpackage Buildfuly/includes
 */

/**
 * Fired during plugin deactivation.
 *
 * This class defines all code necessary to run during the plugin's deactivation.
 *
 * @since      1.0.0
 * @package    Buildfuly
 * @subpackage Buildfuly/includes
 * @author     Buildfuly Team
 */
class Buildfuly_Deactivator {

	/**
	 * Deactivate the plugin.
	 *
	 * Performs cleanup tasks on plugin deactivation.
	 *
	 * @since    1.0.0
	 */
	public static function deactivate() {
		// Flush rewrite rules
		flush_rewrite_rules();
		
		// Note: We don't drop tables on deactivation
		// Tables are only dropped if the user chooses to delete the plugin
		// This preserves user data if they temporarily deactivate the plugin
	}
}
