<?php

/**
 * The plugin bootstrap file
 *
 * This file is read by WordPress to generate the plugin information in the plugin
 * admin area. This file also includes all of the dependencies used by the plugin,
 * registers the activation and deactivation functions, and defines a function
 * that starts the plugin.
 *
 * @link              https://build.fuly.io
 * @since             1.0.0
 * @package           Buildfuly
 *
 * @wordpress-plugin
 * Plugin Name:       Buildfuly - AI Page Builder & Website Creator
 * Plugin URI:        https://build.fuly.io/plugin
 * Description:       AI-powered page builder that generates SEO-optimized landing pages in seconds. Create hero sections, testimonials, pricing tables, FAQs & CTAs with artificial intelligence. Perfect for agencies and freelancers.
 * Version:           1.0.0
 * Author:            Buildfuly
 * Author URI:        https://build.fuly.io
 * License:           GPL-2.0+
 * License URI:       http://www.gnu.org/licenses/gpl-2.0.txt
 * Text Domain:       buildfuly
 * Domain Path:       /languages
 */

// If this file is called directly, abort.
if ( ! defined( 'WPINC' ) ) {
	die;
}

// Define API endpoint for testing (uses Azure/custom domain)
if ( ! defined( 'BUILDFULY_API_URL' ) ) {
	define( 'BUILDFULY_API_URL', 'https://build.fuly.io' );
}

/**
 * Currently plugin version.
 * Start at version 1.0.0 and use SemVer - https://semver.org
 */
define( 'BUILDFULY_VERSION', '1.0.0' );
define( 'BUILDFULY_PLUGIN_DIR', plugin_dir_path( __FILE__ ) );
define( 'BUILDFULY_PLUGIN_URL', plugin_dir_url( __FILE__ ) );
define( 'BUILDFULY_PLUGIN_BASENAME', plugin_basename( __FILE__ ) );

/**
 * The code that runs during plugin activation.
 * This action is documented in includes/class-buildfuly-activator.php
 */
// phpcs:ignore WordPress.NamingConventions.PrefixAllGlobals.NonPrefixedFunctionFound -- Function has buildfuly prefix
function activate_buildfuly() {
	require_once BUILDFULY_PLUGIN_DIR . 'includes/class-buildfuly-activator.php';
	Buildfuly_Activator::activate();
}

/**
 * The code that runs during plugin deactivation.
 * This action is documented in includes/class-buildfuly-deactivator.php
 */
// phpcs:ignore WordPress.NamingConventions.PrefixAllGlobals.NonPrefixedFunctionFound -- Function has buildfuly prefix
function deactivate_buildfuly() {
	require_once BUILDFULY_PLUGIN_DIR . 'includes/class-buildfuly-deactivator.php';
	Buildfuly_Deactivator::deactivate();
}

register_activation_hook( __FILE__, 'activate_buildfuly' );
register_deactivation_hook( __FILE__, 'deactivate_buildfuly' );

/**
 * The core plugin class that is used to define internationalization,
 * admin-specific hooks, and public-facing site hooks.
 */
require BUILDFULY_PLUGIN_DIR . 'includes/class-buildfuly.php';

/**
 * Begins execution of the plugin.
 *
 * Since everything within the plugin is registered via hooks,
 * then kicking off the plugin from this point in the file does
 * not affect the page life cycle.
 *
 * @since    1.0.0
 */
// phpcs:ignore WordPress.NamingConventions.PrefixAllGlobals.NonPrefixedFunctionFound -- Function has buildfuly prefix
function run_buildfuly() {
	$plugin = new Buildfuly();
	$plugin->run();
}
run_buildfuly();
