<?php
/**
 * Provide a styling area view for the plugin
 *
 * This file is used to markup the styling aspects of the plugin.
 *
 * @link       https://build.fuly.io
 * @since      1.0.0
 *
 * @package    Buildfuly
 * @subpackage Buildfuly/admin/partials
 */

// Prevent direct access
if ( ! defined( 'WPINC' ) ) {
	die;
}
?>

<div class="wrap buildfuly-admin-wrap">
	<h1><?php echo esc_html( get_admin_page_title() ); ?></h1>
	
	<div class="buildfuly-container buildfuly-styling-container">
		<!-- Header -->
		<div class="buildfuly-header">
			<div class="buildfuly-logo">
				<h2><?php esc_html_e( 'Styling', 'buildfuly' ); ?></h2>
				<p class="buildfuly-subtitle"><?php esc_html_e( 'Customize colors, fonts, and layout', 'buildfuly' ); ?></p>
			</div>
			<div class="buildfuly-actions">
				<button class="button button-secondary" id="buildfuly-reset-styles">
					<?php esc_html_e( 'Reset to Defaults', 'buildfuly' ); ?>
				</button>
				<button class="button button-primary" id="buildfuly-apply-styles">
					<?php esc_html_e( 'Apply Styles', 'buildfuly' ); ?>
				</button>
			</div>
		</div>

		<!-- Status Messages -->
		<div id="buildfuly-styling-messages" class="buildfuly-messages"></div>

		<!-- Theme Integration Info -->
		<div class="buildfuly-card buildfuly-theme-info">
			<h3><?php esc_html_e( 'Theme Integration', 'buildfuly' ); ?></h3>
			<div id="buildfuly-theme-status">
				<?php esc_html_e( 'Loading theme information...', 'buildfuly' ); ?>
			</div>
		</div>

		<!-- Style Generator -->
		<div class="buildfuly-card">
			<h3><?php esc_html_e( 'Generate Styles', 'buildfuly' ); ?></h3>
			<div class="buildfuly-form-row">
				<div class="buildfuly-form-group">
					<label for="style-business-type"><?php esc_html_e( 'Business Type', 'buildfuly' ); ?></label>
					<select id="style-business-type" class="buildfuly-select">
						<option value="saas"><?php esc_html_e( 'SaaS Company', 'buildfuly' ); ?></option>
						<option value="professional_service"><?php esc_html_e( 'Professional Service', 'buildfuly' ); ?></option>
						<option value="consulting"><?php esc_html_e( 'Consulting', 'buildfuly' ); ?></option>
					</select>
				</div>
				<div class="buildfuly-form-group">
					<label for="style-component"><?php esc_html_e( 'Component (Optional)', 'buildfuly' ); ?></label>
					<select id="style-component" class="buildfuly-select">
						<option value=""><?php esc_html_e( 'All Components', 'buildfuly' ); ?></option>
						<option value="hero"><?php esc_html_e( 'Hero Section', 'buildfuly' ); ?></option>
						<option value="features"><?php esc_html_e( 'Features Section', 'buildfuly' ); ?></option>
						<option value="testimonials"><?php esc_html_e( 'Testimonials Section', 'buildfuly' ); ?></option>
						<option value="cta"><?php esc_html_e( 'CTA Section', 'buildfuly' ); ?></option>
					</select>
				</div>
			</div>
			<div class="buildfuly-form-actions">
				<button class="button button-primary" id="buildfuly-generate-styles">
					<span class="dashicons dashicons-art"></span>
					<?php esc_html_e( 'Generate Styles', 'buildfuly' ); ?>
				</button>
			</div>
		</div>

		<!-- Two Column Layout: Editor + Preview -->
		<div class="buildfuly-two-column">
			<!-- Style Editor -->
			<div class="buildfuly-column buildfuly-editor-column">
				<div class="buildfuly-card">
					<h3><?php esc_html_e( 'Style Editor', 'buildfuly' ); ?></h3>
					
					<!-- Colors Section -->
					<div class="buildfuly-style-section">
						<h4><?php esc_html_e( 'Colors', 'buildfuly' ); ?></h4>
						<div id="buildfuly-colors-editor">
							<!-- React component will mount here -->
						</div>
					</div>

					<!-- Fonts Section -->
					<div class="buildfuly-style-section">
						<h4><?php esc_html_e( 'Typography', 'buildfuly' ); ?></h4>
						<div id="buildfuly-fonts-editor">
							<!-- React component will mount here -->
						</div>
					</div>

					<!-- Layout Section -->
					<div class="buildfuly-style-section">
						<h4><?php esc_html_e( 'Layout', 'buildfuly' ); ?></h4>
						<div id="buildfuly-layout-editor">
							<!-- React component will mount here -->
						</div>
					</div>
				</div>
			</div>

			<!-- Preview Column -->
			<div class="buildfuly-column buildfuly-preview-column">
				<div class="buildfuly-card buildfuly-preview-card">
					<h3><?php esc_html_e( 'Live Preview', 'buildfuly' ); ?></h3>
					<div class="buildfuly-preview-controls">
						<button class="button button-secondary" id="buildfuly-preview-desktop">
							<span class="dashicons dashicons-desktop"></span>
						</button>
						<button class="button button-secondary" id="buildfuly-preview-tablet">
							<span class="dashicons dashicons-tablet"></span>
						</button>
						<button class="button button-secondary" id="buildfuly-preview-mobile">
							<span class="dashicons dashicons-smartphone"></span>
						</button>
					</div>
					<div id="buildfuly-preview" class="buildfuly-preview">
						<!-- Preview will be rendered here -->
					</div>
				</div>
			</div>
		</div>
	</div>
</div>
