<?php
/**
 * License Management Page
 *
 * @link       https://build.fuly.io
 * @since      1.0.0
 *
 * @package    Buildfuly
 * @subpackage Buildfuly/admin/partials
 */

// Prevent direct access
if ( ! defined( 'WPINC' ) ) {
	die;
}

// Load pricing configuration and components
require_once plugin_dir_path( dirname( dirname( __FILE__ ) ) ) . 'includes/class-buildfuly-pricing.php';
require_once plugin_dir_path( dirname( dirname( __FILE__ ) ) ) . 'includes/components/pricing-card.php';

// Get current license information
// phpcs:disable WordPress.NamingConventions.PrefixAllGlobals.NonPrefixedVariableFound -- Template variables, not globals
$license_key = get_option( 'buildfuly_license_key', '' );
$license_status = get_option( 'buildfuly_license_status', 'inactive' );
$license_data = get_option( 'buildfuly_license_data', array() );
$user_tier = get_option( 'buildfuly_user_tier', '' );

// Get all pricing plans
$plans = Buildfuly_Pricing::get_all_plans();

// Handle activation/deactivation
$message = '';
$message_type = '';

if ( isset( $_POST['buildfuly_activate_license'] ) && check_admin_referer( 'buildfuly_license_action', 'buildfuly_license_nonce' ) ) {
	$new_license_key = isset( $_POST['buildfuly_license_key'] ) ? sanitize_text_field( wp_unslash( $_POST['buildfuly_license_key'] ) ) : '';
	
	require_once plugin_dir_path( dirname( dirname( __FILE__ ) ) ) . 'includes/class-buildfuly-api-client.php';
	require_once plugin_dir_path( dirname( dirname( __FILE__ ) ) ) . 'includes/class-buildfuly-license.php';
	$license_manager = new Buildfuly_License();
	
	$result = $license_manager->activate( $new_license_key );
	
	if ( is_wp_error( $result ) ) {
		$message = $result->get_error_message();
		$message_type = 'error';
	} else {
		$message = 'License activated successfully!';
		$message_type = 'success';
		// Refresh data
		$license_key = get_option( 'buildfuly_license_key', '' );
		$license_status = get_option( 'buildfuly_license_status', 'inactive' );
		$license_data = get_option( 'buildfuly_license_data', array() );
		$user_tier = get_option( 'buildfuly_user_tier', '' );
	}
}

if ( isset( $_POST['buildfuly_deactivate_license'] ) && check_admin_referer( 'buildfuly_license_action', 'buildfuly_license_nonce' ) ) {
	require_once plugin_dir_path( dirname( dirname( __FILE__ ) ) ) . 'includes/class-buildfuly-api-client.php';
	require_once plugin_dir_path( dirname( dirname( __FILE__ ) ) ) . 'includes/class-buildfuly-license.php';
	$license_manager = new Buildfuly_License();
	
	$result = $license_manager->deactivate();
	
	if ( is_wp_error( $result ) ) {
		$message = $result->get_error_message();
		$message_type = 'error';
	} else {
		$message = 'License deactivated successfully.';
		$message_type = 'success';
		// Refresh data
		$license_key = '';
		$license_status = 'inactive';
		$license_data = array();
		$user_tier = '';
	}
}
// phpcs:enable WordPress.NamingConventions.PrefixAllGlobals.NonPrefixedVariableFound
?>

<div class="wrap buildfuly-admin-wrap">
	<h1><?php echo esc_html( get_admin_page_title() ); ?></h1>
	
	<?php if ( $message ) : ?>
		<div class="notice notice-<?php echo esc_attr( $message_type ); ?> is-dismissible">
			<p><?php echo esc_html( $message ); ?></p>
		</div>
	<?php endif; ?>
	
	<div class="buildfuly-container">
		
		<!-- License Status Card -->
		<div class="buildfuly-card">
			<h2><?php esc_html_e( '🔑 License Status', 'buildfuly' ); ?></h2>
			
			<?php if ( $license_status === 'active' && ! empty( $license_key ) ) : ?>
				<!-- Active License -->
				<div class="license-status-active" style="padding: 20px; background: #d4edda; border: 1px solid #c3e6cb; border-radius: 4px; margin-bottom: 20px;">
					<div style="display: flex; align-items: center; gap: 12px; margin-bottom: 16px;">
						<span class="dashicons dashicons-yes-alt" style="color: #155724; font-size: 32px; width: 32px; height: 32px;"></span>
						<div>
							<h3 style="margin: 0; color: #155724;">✅ License Active</h3>
							<p style="margin: 4px 0 0; color: #155724;">Your Buildfuly license is active and working.</p>
						</div>
					</div>
					
					<table class="form-table">
						<tr>
							<th scope="row"><?php esc_html_e( 'License Key', 'buildfuly' ); ?></th>
							<td>
								<code style="background: #fff; padding: 8px 12px; border-radius: 4px; display: inline-block;">
									<?php echo esc_html( $license_key ); ?>
								</code>
							</td>
						</tr>
						<tr>
							<th scope="row"><?php esc_html_e( 'Plan', 'buildfuly' ); ?></th>
							<td>
								<strong><?php echo esc_html( ucfirst( $user_tier ) ); ?></strong>
								<?php if ( isset( $license_data['license']['pages_per_day'] ) ) : ?>
									<br>
									<span class="description">
										<?php echo esc_html( $license_data['license']['pages_per_day'] ); ?> pages per day
									</span>
								<?php endif; ?>
							</td>
						</tr>
						<?php if ( isset( $license_data['user']['email'] ) ) : ?>
						<tr>
							<th scope="row"><?php esc_html_e( 'Email', 'buildfuly' ); ?></th>
							<td><?php echo esc_html( $license_data['user']['email'] ); ?></td>
						</tr>
						<?php endif; ?>
					</table>
					
					<form method="post" style="margin-top: 20px;">
						<?php wp_nonce_field( 'buildfuly_license_action', 'buildfuly_license_nonce' ); ?>
						<button type="submit" 
								name="buildfuly_deactivate_license" 
								class="button button-secondary"
								onclick="return confirm('Are you sure you want to deactivate this license?');">
							<?php esc_html_e( 'Deactivate License', 'buildfuly' ); ?>
						</button>
					</form>
				</div>
				
			<?php else : ?>
				<!-- No Active License -->
				<div class="license-status-inactive" style="padding: 20px; background: #fff3cd; border: 1px solid #ffc107; border-radius: 4px; margin-bottom: 20px;">
					<div style="display: flex; align-items: center; gap: 12px; margin-bottom: 16px;">
						<span class="dashicons dashicons-warning" style="color: #856404; font-size: 32px; width: 32px; height: 32px;"></span>
						<div>
							<h3 style="margin: 0; color: #856404;">⚠️ No Active License</h3>
							<p style="margin: 4px 0 0; color: #856404;">Activate your license to unlock all features.</p>
						</div>
					</div>
					
					<form method="post">
						<?php wp_nonce_field( 'buildfuly_license_action', 'buildfuly_license_nonce' ); ?>
						
						<table class="form-table">
							<tr>
								<th scope="row">
									<label for="buildfuly_license_key">
										<?php esc_html_e( 'License Key', 'buildfuly' ); ?>
									</label>
								</th>
								<td>
									<input type="text" 
										   id="buildfuly_license_key" 
										   name="buildfuly_license_key" 
										   value="<?php echo esc_attr( $license_key ); ?>" 
										   class="regular-text" 
										   placeholder="XXXX-XXXX-XXXX-XXXX"
										   required>
									<p class="description">
										<?php esc_html_e( 'Enter your license key from your purchase email.', 'buildfuly' ); ?>
									</p>
								</td>
							</tr>
						</table>
						
						<p class="submit">
							<button type="submit" 
									name="buildfuly_activate_license" 
									class="button button-primary button-large">
								<?php esc_html_e( 'Activate License', 'buildfuly' ); ?>
							</button>
						</p>
					</form>
				</div>
			<?php endif; ?>
		</div>
		
		<!-- Purchase License Section -->
		<div class="buildfuly-card pricing-section">
			<div class="section-header">
				<h2><?php esc_html_e( 'Choose Your Plan', 'buildfuly' ); ?></h2>
				<p class="section-description">
					<?php esc_html_e( 'Select the perfect plan for your needs. All plans include AI-powered page generation and unlimited updates.', 'buildfuly' ); ?>
				</p>
			</div>

			<?php
			// Render pricing cards using shared component
			buildfuly_render_pricing_cards( array(
				'show_toggle'    => true,
				'show_lifetime'  => true,
				'current_tier'   => $user_tier,
				'cta_url'        => 'https://build.fuly.io/checkout/{tier}/{period}',
				'show_free_tier' => true,
			) );
			?>

			<div class="pricing-footer">
				<p class="need-help">
					<?php esc_html_e( 'Need help choosing? ', 'buildfuly' ); ?>
					<a href="https://build.fuly.io/compare-plans" target="_blank">
						<?php esc_html_e( 'Compare all plans →', 'buildfuly' ); ?>
					</a>
				</p>
			</div>
		</div>
		
	
		
	</div>
</div>

<style>
.buildfuly-admin-wrap {
	background: #f5f5f7;
	margin: 20px 0 20px -20px;
	padding: 40px 20px;
	min-height: calc(100vh - 100px);
}

.buildfuly-container {
	max-width: 1400px;
	margin: 0 auto;
}

.buildfuly-card {
	background: white;
	border-radius: 16px;
	padding: 32px;
	margin-bottom: 24px;
	box-shadow: 0 2px 12px rgba(0,0,0,0.06);
	transition: all 0.3s ease;
}

.buildfuly-card:hover {
	box-shadow: 0 4px 20px rgba(0,0,0,0.08);
}

.buildfuly-card h2 {
	margin-top: 0;
	font-size: 24px;
	font-weight: 700;
	color: #1d1d1f;
	letter-spacing: -0.5px;
}

/* License Status */
.license-status-active,
.license-status-inactive {
	padding: 24px;
	border-radius: 12px;
	margin-bottom: 24px;
}

.license-status-active {
	background: linear-gradient(135deg, #d4edda 0%, #c3e6cb 100%);
	border: 2px solid #34c759;
}

.license-status-inactive {
	background: linear-gradient(135deg, #fff3cd 0%, #ffeaa7 100%);
	border: 2px solid #fbbf24;
}

/* Pricing Section */
.pricing-section {
	padding: 48px 32px;
}

.section-header {
	text-align: center;
	margin-bottom: 48px;
}

.section-header h2 {
	font-size: 36px;
	margin-bottom: 12px;
}

.section-description {
	font-size: 17px;
	color: #86868b;
	max-width: 600px;
	margin: 0 auto 16px;
	line-height: 1.5;
}

.hosting-note {
	display: inline-flex;
	align-items: center;
	padding: 12px 20px;
	background: #fef3c7;
	border: 1px solid #fbbf24;
	border-radius: 12px;
	font-size: 14px;
	color: #78350f;
	margin-top: 16px;
}

.pricing-footer {
	text-align: center;
	margin-top: 48px;
	padding-top: 32px;
	border-top: 1px solid #e5e5e7;
}

.need-help {
	font-size: 16px;
	color: #86868b;
}

.need-help a {
	color: #007aff;
	text-decoration: none;
	font-weight: 600;
}

.need-help a:hover {
	text-decoration: underline;
}

/* Form Elements */
.form-table th {
	font-weight: 600;
	color: #1d1d1f;
}

.form-table input[type="text"] {
	border-radius: 8px;
	border: 1px solid #d1d1d6;
	padding: 10px 14px;
	font-size: 15px;
}

.form-table input[type="text"]:focus {
	border-color: #007aff;
	box-shadow: 0 0 0 3px rgba(0, 122, 255, 0.1);
	outline: none;
}

/* Buttons */
.button {
	border-radius: 10px;
	padding: 10px 20px;
	font-weight: 600;
	transition: all 0.3s ease;
}

.button-primary {
	background: linear-gradient(135deg, #007aff, #0051d5);
	border: none;
	box-shadow: 0 2px 12px rgba(0, 122, 255, 0.3);
}

.button-primary:hover {
	transform: translateY(-2px);
	box-shadow: 0 4px 20px rgba(0, 122, 255, 0.4);
}

.button-secondary {
	background: white;
	border: 2px solid #e5e5e7;
	color: #1d1d1f;
}

.button-secondary:hover {
	border-color: #007aff;
	color: #007aff;
}

code {
	background: #f5f5f7;
	padding: 4px 8px;
	border-radius: 6px;
	font-family: 'SF Mono', 'Monaco', 'Inconsolata', 'Courier New', monospace;
	font-size: 13px;
	color: #af52de;
}
</style>
