<?php
/**
 * Enhanced Generation Settings
 *
 * @link       https://build.fuly.io
 * @since      1.0.3
 *
 * @package    Buildfuly
 * @subpackage Buildfuly/admin/partials
 */

// Prevent direct access
if ( ! defined( 'WPINC' ) ) {
	die;
}

// phpcs:disable WordPress.NamingConventions.PrefixAllGlobals.NonPrefixedVariableFound -- Template variables, not globals
$generation_mode = get_option( 'buildfuly_generation_mode', 'keyword' );
$generation_instructions = get_option( 'buildfuly_generation_instructions', '' );
$cta_buttons = json_decode( get_option( 'buildfuly_cta_buttons', '[]' ), true );
$contact_form_embed = get_option( 'buildfuly_contact_form_embed', '' );

// Ensure at least one button exists
if ( empty( $cta_buttons ) ) {
	$cta_buttons = array(
		array( 'text' => 'Get Started', 'url' => '#contact', 'style' => 'primary' )
	);
}
// phpcs:enable WordPress.NamingConventions.PrefixAllGlobals.NonPrefixedVariableFound
?>

<!-- CTA Buttons Management -->
<div class="buildfuly-card">
	<h3><?php esc_html_e( '🔘 Call-to-Action Buttons', 'buildfuly' ); ?></h3>
	<p class="description">
		<?php esc_html_e( 'Configure buttons that appear across all components. At least one button is required.', 'buildfuly' ); ?>
	</p>
	<form method="post" action="options.php" id="buildfuly-buttons-form">
		<?php settings_fields( 'buildfuly_business_settings' ); ?>

		<div id="button-list">
			<?php 
			// phpcs:ignore WordPress.NamingConventions.PrefixAllGlobals.NonPrefixedVariableFound -- Foreach loop variables
			foreach ( $cta_buttons as $index => $button ) : 
			?>
		<div class="button-row" data-index="<?php echo esc_attr( $index ); ?>" style="background: #f9fafb; padding: 20px; border-radius: 8px; margin-bottom: 16px; border: 2px solid #e5e7eb;">
			<div style="display: flex; align-items: center; margin-bottom: 12px;">
				<h4 style="margin: 0;">
					<?php 
					/* translators: %d: Button number (e.g., 1, 2, 3) */
					printf( esc_html__( 'Button %d', 'buildfuly' ), esc_html( $index + 1 ) ); 
					?>
					<?php if ( $index === 0 ) : ?>
						<span style="background: #10b981; color: white; padding: 2px 8px; border-radius: 4px; font-size: 11px; font-weight: 600; margin-left: 8px;">PRIMARY</span>
					<?php endif; ?>
					</h4>
					<?php if ( $index > 0 ) : ?>
					<button type="button" class="button remove-button-btn" data-index="<?php echo esc_attr( $index ); ?>">
						<?php esc_html_e( 'Remove', 'buildfuly' ); ?>
					</button>
					<?php endif; ?>
				</div>
				
				<table class="form-table" style="margin: 0;">
					<tr>
						<th style="width: 120px; padding-left: 0;">
							<label><?php esc_html_e( 'Button Text', 'buildfuly' ); ?></label>
						</th>
						<td>
							<input type="text" 
								   name="button_text_<?php echo esc_attr( $index ); ?>" 
								   value="<?php echo esc_attr( $button['text'] ); ?>" 
								   class="regular-text"
								   required
								   placeholder="<?php esc_attr_e( 'Get Started', 'buildfuly' ); ?>">
						</td>
					</tr>
					<tr>
						<th style="padding-left: 0;">
							<label><?php esc_html_e( 'Link URL', 'buildfuly' ); ?></label>
						</th>
						<td>
							<input type="url" 
								   name="button_url_<?php echo esc_attr( $index ); ?>" 
								   value="<?php echo esc_attr( $button['url'] ); ?>" 
								   class="large-text"
								   required
								   placeholder="<?php esc_attr_e( 'https://example.com/contact or #contact', 'buildfuly' ); ?>">
							<p class="description"><?php esc_html_e( 'Full URL or anchor link (e.g., #contact)', 'buildfuly' ); ?></p>
						</td>
					</tr>
					<tr>
						<th style="padding-left: 0;">
							<label><?php esc_html_e( 'Style', 'buildfuly' ); ?></label>
						</th>
						<td>
							<select name="button_style_<?php echo esc_attr( $index ); ?>" class="regular-text">
								<option value="primary" <?php selected( $button['style'], 'primary' ); ?>>
									<?php esc_html_e( 'Primary (Solid background)', 'buildfuly' ); ?>
								</option>
								<option value="secondary" <?php selected( $button['style'], 'secondary' ); ?>>
									<?php esc_html_e( 'Secondary (Outline)', 'buildfuly' ); ?>
								</option>
							</select>
						</td>
					</tr>
				</table>
			</div>
			<?php endforeach; ?>
		</div>

		<button type="button" id="add-button-btn" class="button button-secondary" style="margin-bottom: 20px;">
			<span class="dashicons dashicons-plus-alt" style="vertical-align: middle; margin-top: 4px;"></span>
			<?php esc_html_e( 'Add Another Button', 'buildfuly' ); ?>
		</button>

		<input type="hidden" name="buildfuly_cta_buttons" id="buildfuly_cta_buttons" value="">

		<?php submit_button( __( 'Save Buttons', 'buildfuly' ) ); ?>
	</form>
</div>

<!-- Contact Form Integration -->
<div class="buildfuly-card">
	<h3><?php esc_html_e( '📧 Contact Form Integration', 'buildfuly' ); ?></h3>
	<p class="description">
		<?php esc_html_e( 'Add a contact form to your landing pages. Paste the embed code from your form plugin.', 'buildfuly' ); ?>
	</p>
	<form method="post" action="options.php" id="buildfuly-contact-form">
		<?php settings_fields( 'buildfuly_business_settings' ); ?>
		
		<table class="form-table">
			<tr>
				<th scope="row">
					<label for="buildfuly_contact_form_embed"><?php esc_html_e( 'Form Embed Code', 'buildfuly' ); ?></label>
				</th>
				<td>
					<textarea id="buildfuly_contact_form_embed" 
							  name="buildfuly_contact_form_embed" 
							  rows="6" 
							  class="large-text code"
							  placeholder='<?php esc_attr_e( 'Paste your form shortcode or embed code here, e.g., [contact-form-7 id="123"] or <iframe>...</iframe>', 'buildfuly' ); ?>'><?php echo esc_textarea( $contact_form_embed ); ?></textarea>
					<p class="description">
						<?php esc_html_e( 'Supports: Contact Form 7, WPForms, Gravity Forms, Formidable, or any HTML embed code.', 'buildfuly' ); ?>
					</p>
				</td>
			</tr>
		</table>

		<div style="background: #ecfdf5; border-left: 4px solid #10b981; padding: 20px; border-radius: 8px; margin: 20px 0;">
			<h4 style="margin-top: 0; color: #047857;">
				✓ <?php esc_html_e( 'Once configured, a "Contact Form" component will be available', 'buildfuly' ); ?>
			</h4>
			<p style="margin: 0; color: #065f46;">
				<?php esc_html_e( 'When adding sections to your landing page, you\'ll see "Contact Form" as an option if a form is configured here.', 'buildfuly' ); ?>
			</p>
		</div>

		<?php if ( empty( $contact_form_embed ) ) : ?>
		<div style="background: #fffbeb; border: 1px solid #fde68a; padding: 16px; border-radius: 8px; margin: 20px 0;">
			<p style="margin: 0; font-size: 14px; color: #92400e;">
				<strong>💡 <?php esc_html_e( 'Need a form plugin?', 'buildfuly' ); ?></strong><br>
				<?php esc_html_e( 'We recommend', 'buildfuly' ); ?> 
				<a href="<?php echo esc_url( admin_url( 'plugin-install.php?s=contact+form+7&tab=search' ) ); ?>" target="_blank">Contact Form 7</a> 
				<?php esc_html_e( '(free) or', 'buildfuly' ); ?> 
				<a href="<?php echo esc_url( admin_url( 'plugin-install.php?s=wpforms&tab=search' ) ); ?>" target="_blank">WPForms</a> 
				<?php esc_html_e( '(drag & drop builder).', 'buildfuly' ); ?>
			</p>
		</div>
		<?php endif; ?>

		<?php submit_button( __( 'Save Contact Form', 'buildfuly' ) ); ?>
	</form>
</div>

<script>
jQuery(document).ready(function($) {
	// Button management
	let buttonIndex = <?php echo count( $cta_buttons ); ?>;

	// Add button
	$('#add-button-btn').on('click', function() {
		const newButton = `
			<div class="button-row" data-index="${buttonIndex}" style="background: #f9fafb; padding: 20px; border-radius: 8px; margin-bottom: 16px; border: 2px solid #e5e7eb;">
				<div style="display: flex; justify-content: space-between; align-items: center; margin-bottom: 12px;">
					<h4 style="margin: 0;">Button ${buttonIndex + 1}</h4>
					<button type="button" class="button remove-button-btn" data-index="${buttonIndex}">Remove</button>
				</div>
				<table class="form-table" style="margin: 0;">
					<tr>
						<th style="width: 120px; padding-left: 0;">
							<label>Button Text</label>
						</th>
						<td>
							<input type="text" name="button_text_${buttonIndex}" value="" class="regular-text" required placeholder="Get Started">
						</td>
					</tr>
					<tr>
						<th style="padding-left: 0;">
							<label>Link URL</label>
						</th>
						<td>
							<input type="url" name="button_url_${buttonIndex}" value="" class="large-text" required placeholder="https://example.com or #contact">
							<p class="description">Full URL or anchor link (e.g., #contact)</p>
						</td>
					</tr>
					<tr>
						<th style="padding-left: 0;">
							<label>Style</label>
						</th>
						<td>
							<select name="button_style_${buttonIndex}" class="regular-text">
								<option value="primary">Primary (Solid background)</option>
								<option value="secondary">Secondary (Outline)</option>
							</select>
						</td>
					</tr>
				</table>
			</div>
		`;
		$('#button-list').append(newButton);
		buttonIndex++;
	});

	// Remove button
	$(document).on('click', '.remove-button-btn', function() {
		$(this).closest('.button-row').slideUp(300, function() {
			$(this).remove();
			// Renumber buttons
			$('.button-row').each(function(i) {
				$(this).find('h4').first().text('Button ' + (i + 1));
			});
		});
	});

	// Before submit, collect button data into JSON
	$('#buildfuly-buttons-form').on('submit', function(e) {
		const buttons = [];
		$('.button-row').each(function() {
			const index = $(this).data('index');
			const text = $(`input[name="button_text_${index}"]`).val();
			const url = $(`input[name="button_url_${index}"]`).val();
			const style = $(`select[name="button_style_${index}"]`).val();
			
			if (text && url) {
				buttons.push({ text: text, url: url, style: style });
			}
		});
		
		// Must have at least one button
		if (buttons.length === 0) {
			e.preventDefault();
			alert('<?php esc_html_e( 'At least one button is required.', 'buildfuly' ); ?>');
			return false;
		}
		
		$('#buildfuly_cta_buttons').val(JSON.stringify(buttons));
	});
});
</script>
