<?php
/**
 * Provide a admin area view for the plugin
 *
 * This file is used to markup the admin-facing aspects of the plugin.
 *
 * @link       https://build.fuly.io
 * @since      1.0.0
 *
 * @package    Buildfuly
 * @subpackage Buildfuly/admin/partials
 */

// Prevent direct access
if ( ! defined( 'WPINC' ) ) {
	die;
}

// Check theme compatibility
// phpcs:disable WordPress.NamingConventions.PrefixAllGlobals.NonPrefixedVariableFound -- Template variables
$admin = new Buildfuly_Admin( 'buildfuly', BUILDFULY_VERSION );
$theme_check = $admin->check_theme_compatibility();
// phpcs:enable WordPress.NamingConventions.PrefixAllGlobals.NonPrefixedVariableFound
?>

<div class="wrap buildfuly-admin-wrap">
	<input type="hidden" id="buildfuly-nonce" value="<?php echo esc_attr( wp_create_nonce('buildfuly-admin') ); ?>">
	
	<!-- Message Container -->
	<div id="buildfuly-messages" style="position: fixed; top: 32px; right: 20px; z-index: 10000; width: 400px;"></div>
	
	<div class="buildfuly-container">
		<!-- Theme Notice (compact) -->
	<?php if ( ! $theme_check['active'] ) : ?>
	<div class="buildfuly-theme-banner">
		<span>⚠️ Compatible theme recommended</span>
		<div>
			<a href="<?php echo esc_url( admin_url('theme-install.php?search=generatepress') ); ?>" class="buildfuly-theme-link">Install GeneratePress</a>
			<a href="<?php echo esc_url( admin_url('theme-install.php?search=kadence') ); ?>" class="buildfuly-theme-link">Install Kadence</a>
		</div>
	</div>
	<?php endif; ?>		<!-- Status Messages -->
		<div id="buildfuly-messages"></div>

		<!-- Page Builder Interface -->
		<div class="buildfuly-page-builder">
			<!-- Floating Sidebar Toggle (shows when collapsed) -->
			<button class="buildfuly-sidebar-expand" id="buildfuly-sidebar-expand" title="Expand Sidebar">
				<span class="dashicons dashicons-arrow-right-alt2"></span>
			</button>
			
			<!-- Floating Sidebar Collapse (shows when expanded) -->
			<button class="buildfuly-sidebar-collapse-float" id="buildfuly-sidebar-collapse-float" title="Collapse Sidebar">
				<span class="dashicons dashicons-arrow-left-alt2"></span>
			</button>
			
		<!-- Page Selection Sidebar -->
		<div class="buildfuly-pages-sidebar" id="buildfuly-pages-sidebar">
			<div class="buildfuly-sidebar-header">
				<div style="display: flex; align-items: center; justify-content: space-between;">
					<div style="display: flex; align-items: center; gap: 12px;">
						<button class="buildfuly-sidebar-toggle" id="buildfuly-sidebar-toggle" title="Toggle Sidebar">
							<span class="dashicons dashicons-arrow-left-alt2"></span>
						</button>
						<h3 style="margin: 0; font-family: 'SF Pro Display', -apple-system, BlinkMacSystemFont, 'Segoe UI', sans-serif; font-weight: 700; font-size: 20px; background: linear-gradient(135deg, #667eea 0%, #764ba2 100%); -webkit-background-clip: text; -webkit-text-fill-color: transparent; background-clip: text;">Buildfuly</h3>
					</div>
				</div>

				<!-- Tab Switcher -->
				<div class="buildfuly-tab-switcher" style="display: flex; gap: 4px; margin-top: 12px; background: #f3f4f6; padding: 4px; border-radius: 8px;">
					<button class="buildfuly-tab-btn active" data-tab="pages" style="flex: 1; padding: 8px 12px; border: none; background: white; border-radius: 6px; font-size: 13px; font-weight: 600; color: #374151; cursor: pointer; display: flex; align-items: center; justify-content: center; gap: 6px; box-shadow: 0 1px 2px rgba(0,0,0,0.05);">
						<span class="dashicons dashicons-admin-page" style="font-size: 16px; width: 16px; height: 16px;"></span>
						Pages
					</button>
					<button class="buildfuly-tab-btn" data-tab="blogs" style="flex: 1; padding: 8px 12px; border: none; background: transparent; border-radius: 6px; font-size: 13px; font-weight: 600; color: #6b7280; cursor: pointer; display: flex; align-items: center; justify-content: center; gap: 6px;">
						<span class="dashicons dashicons-edit" style="font-size: 16px; width: 16px; height: 16px;"></span>
						Blogs
					</button>
				</div>

			<div style="padding: 8px 12px; background: #f0f9ff; border-radius: 8px; border: 1px solid #bfdbfe; margin-top: 8px;">
				<div style="font-size: 12px; color: #1e40af; font-weight: 600;" id="buildfuly-usage-display">
					<span id="buildfuly-pages-remaining">–</span> <span id="buildfuly-pages-text">pages remaining</span>
					<div style="font-size: 11px; color: #3b82f6; margin-top: 2px;">
						(~<span id="buildfuly-words-count">–</span> words)
					</div>
				</div>
			</div>

				<!-- Pages Tab Content -->
				<div class="buildfuly-tab-content active" id="buildfuly-tab-pages">
					<button class="buildfuly-control-btn buildfuly-control-btn-primary" id="buildfuly-new-page">
						<span class="dashicons dashicons-plus-alt"></span>
						New Page
					</button>
					<button class="buildfuly-control-btn buildfuly-control-btn-secondary" id="buildfuly-generate-more-pages" style="margin-top: 8px;">
						<span class="dashicons dashicons-lightbulb"></span>
						Generate More Pages
					</button>
				</div>

				<!-- Blogs Tab Content -->
				<div class="buildfuly-tab-content" id="buildfuly-tab-blogs">
					<button class="buildfuly-control-btn buildfuly-control-btn-primary" id="buildfuly-new-blog">
						<span class="dashicons dashicons-plus-alt"></span>
						New Blog Post
					</button>
					<button class="buildfuly-control-btn buildfuly-control-btn-secondary" id="buildfuly-generate-more-blogs" style="margin-top: 8px;">
						<span class="dashicons dashicons-lightbulb"></span>
						Generate Blog Ideas
					</button>
				</div>
			</div>
			<div id="buildfuly-pages-list" class="buildfuly-pages-list">
					<!-- Pages will be listed here -->
				</div>
			<div id="buildfuly-blogs-list" class="buildfuly-pages-list" style="display: none;">
					<!-- Blogs will be listed here -->
				</div>
			</div>

			<!-- Main Content Area -->
			<div class="buildfuly-workspace">
				<!-- Top Control Bar (Regenerate + Device Preview) -->

				
				<!-- New Page Modal (shown on first load or new page click) -->
				<div id="buildfuly-new-page-modal" class="buildfuly-modal" style="display: none;">
					<div class="buildfuly-modal-content" style="max-width: 700px;">
						<div class="buildfuly-modal-header">
							<h2>Create New Page</h2>
							<button class="buildfuly-modal-close">&times;</button>
						</div>
						<div class="buildfuly-modal-body">
							<!-- Step 1: Page Description -->
							<div id="buildfuly-page-step-1">
								<div class="buildfuly-form-group">
									<label for="page-type">What type of page do you want to build?</label>
									<input type="text" id="page-type" class="buildfuly-control-input" placeholder="e.g., Homepage, About Us, Services, Contact, Pricing..." style="width: 100%; margin-bottom: 8px;">
									<p class="description">Describe the page and we'll generate relevant keywords for you</p>
								</div>
								<div class="buildfuly-form-group" style="margin-top: 24px;">
									<button type="button" class="button button-primary" id="buildfuly-analyze-page" style="width: 100%;">
										<span class="dashicons dashicons-analytics"></span>
										Analyze & Generate Keywords
									</button>
								</div>
							</div>

							<!-- Step 2: Layout Customization (shown after analysis) -->
							<div id="buildfuly-page-step-2" style="display: none;">
								<div class="buildfuly-form-group">
									<label for="page-title-input">Page Title</label>
									<input type="text" id="page-title-input" class="buildfuly-control-input" placeholder="e.g., Home, About Us, Our Services..." style="width: 100%;">
									<p class="description">This will be the page title in WordPress (you can change this later)</p>
								</div>
								<div class="buildfuly-form-group" style="margin-top: 16px;">
									<label for="page-keywords">SEO Keywords</label>
									<input type="text" id="page-keywords" class="buildfuly-control-input" placeholder="Keywords will be generated..." style="width: 100%;">
									<p class="description">Generated from your page description (you can edit these)</p>
								</div>

								<!-- Layout Preview & Customization -->
								<div class="buildfuly-form-group" style="margin-top: 24px; padding: 20px; background: #f9fafb; border-radius: 8px; border: 1px solid #e5e7eb;">
									<h3 style="margin: 0 0 16px 0; font-size: 14px; font-weight: 600; display: flex; align-items: center; gap: 8px;">
										<span class="dashicons dashicons-layout"></span>
										Customize Page Layout
									</h3>

									<!-- Component Count Slider -->
									<div style="margin-bottom: 20px;">
										<label for="buildfuly-component-count" style="display: flex; justify-content: space-between; margin-bottom: 8px;">
											<span>Number of Components</span>
											<span id="buildfuly-component-count-label" style="font-weight: 600; color: #2563eb;">6</span>
										</label>
										<input type="range" id="buildfuly-component-count" min="3" max="8" value="6" step="1" style="width: 100%;">
									</div>

									<!-- Options -->
									<div style="display: flex; gap: 16px; margin-bottom: 20px;">
										<label style="display: flex; align-items: center; gap: 8px; cursor: pointer;">
											<input type="checkbox" id="buildfuly-no-hero" style="margin: 0;">
											<span>No Hero</span>
										</label>
										<label style="display: flex; align-items: center; gap: 8px; cursor: pointer;">
											<input type="checkbox" id="buildfuly-no-testimonials" style="margin: 0;">
											<span>No Testimonials</span>
										</label>
										<label style="display: flex; align-items: center; gap: 8px; cursor: pointer;">
											<input type="checkbox" id="buildfuly-randomize-layout" style="margin: 0;">
											<span>Randomize Each Time</span>
										</label>
									</div>

									<!-- Word Estimation -->
									<div style="margin-bottom: 16px; padding: 12px; background: #f9fafb; border-radius: 4px; border-left: 3px solid #667eea;">
										<div style="display: flex; justify-content: space-between; align-items: center;">
											<span style="font-size: 13px; color: #374151;">Estimated Words:</span>
											<span id="buildfuly-word-estimate" style="font-weight: 600; font-size: 14px; color: #667eea;">~1,800</span>
										</div>
									</div>

									<!-- Layout Preview -->
									<div style="background: white; border: 1px solid #e5e7eb; border-radius: 6px; padding: 16px;">
										<div style="font-size: 12px; font-weight: 600; color: #6b7280; margin-bottom: 12px; text-transform: uppercase; letter-spacing: 0.5px;">
											Preview Layout
										</div>
										<div id="buildfuly-layout-preview" style="display: flex; flex-direction: column; gap: 8px;">
											<!-- Component list will be populated here -->
										</div>
									</div>
								</div>

								<!-- Images Section -->
								<div class="buildfuly-form-group" style="margin-top: 24px; padding-top: 24px; border-top: 1px solid #e5e7eb;">
									<label>Page Images</label>
									<p class="description">Choose how to add images to your page components.</p>
									
									<!-- Auto-Generate Images Option -->
									<div style="margin: 16px 0; padding: 16px; background: linear-gradient(135deg, #f0f9ff 0%, #e0f2fe 100%); border: 1px solid #7dd3fc; border-radius: 8px;">
										<label style="display: flex; align-items: flex-start; gap: 12px; cursor: pointer;">
											<input type="checkbox" id="buildfuly-auto-generate-images" style="width: 18px; height: 18px; margin-top: 2px; cursor: pointer;">
											<div style="flex: 1;">
												<strong style="display: block; font-size: 14px; color: #0369a1;">
													<span class="dashicons dashicons-art" style="font-size: 16px; width: 16px; height: 16px;"></span>
													Auto-Generate AI Images
												</strong>
												<span style="font-size: 12px; color: #0284c7; display: block; margin-top: 4px;">
													AI will create unique images for each section based on your page content (costs 500 words per image)
												</span>
												
												<!-- Sub-options (shown when checkbox is checked) -->
												<div id="buildfuly-auto-image-options" style="display: none; margin-top: 12px; padding-top: 12px; border-top: 1px solid rgba(125, 211, 252, 0.5);">
													<label style="display: flex; align-items: center; gap: 8px; cursor: pointer; margin-bottom: 8px;">
														<input type="checkbox" id="buildfuly-auto-pick-images" style="cursor: pointer;">
														<span style="font-size: 13px; color: #0369a1;">Auto-pick reference images (faster, less control)</span>
													</label>
													<label style="display: flex; align-items: center; gap: 8px; cursor: pointer;">
														<input type="checkbox" id="buildfuly-include-logo-images" style="cursor: pointer;">
														<span style="font-size: 13px; color: #0369a1;">Add logo to uniforms/clothing in images</span>
													</label>
												</div>
											</div>
										</label>
									</div>

									<!-- Manual Images Section (shown when auto-generate is unchecked) -->
									<div id="buildfuly-manual-images-section">
										<p class="description" style="margin-top: 8px;">Or upload your own images (3-7 recommended):</p>
										<div id="buildfuly-page-images-preview" style="display: grid; grid-template-columns: repeat(auto-fill, minmax(120px, 1fr)); gap: 12px; margin: 16px 0;">
											<!-- Images will be added here -->
										</div>
										<button type="button" class="button button-secondary" id="buildfuly-upload-page-images">
											<span class="dashicons dashicons-format-gallery" style="margin-top: 3px;"></span>
											Add Images (3-7 recommended)
										</button>
									</div>
									<input type="hidden" id="buildfuly-page-images-ids" value="">
								</div>

								<div style="margin-top: 16px; text-align: center;">
									<button type="button" class="button button-link" id="buildfuly-back-to-description">
										← Back to Description
									</button>
								</div>
							</div>
						</div>
						<div class="buildfuly-modal-footer">
							<button class="button button-secondary" id="buildfuly-cancel-page">Cancel</button>
							<button class="button button-primary" id="buildfuly-create-page" style="display: none;">
								<span class="dashicons dashicons-superhero-alt"></span>
								Generate Page with AI
							</button>
						</div>
					</div>
				</div>

				<!-- Color Palette Bar (shows when page is loaded) -->
				<div class="buildfuly-color-bar" id="buildfuly-color-bar" style="display: none;">
					<div style="display: flex; align-items: center; gap: 8px; flex: 1;">
						<div style="display: flex; align-items: center; gap: 10px; cursor: pointer;" id="buildfuly-colors-toggle">
							<span class="dashicons dashicons-arrow-right-alt2" id="buildfuly-colors-arrow"></span>
							<div class="buildfuly-color-label">Global colors</div>
						</div>
						<div class="buildfuly-color-swatches-mini" id="buildfuly-color-swatches-mini">
							<!-- Colors populated by JavaScript from global theme settings -->
							<div class="buildfuly-color-mini" data-color="primary"></div>
							<div class="buildfuly-color-mini" data-color="secondary"></div>
							<div class="buildfuly-color-mini" data-color="text"></div>
							<div class="buildfuly-color-mini" data-color="text-light"></div>
							<div class="buildfuly-color-mini" data-color="bg"></div>
						</div>
						<div class="buildfuly-color-swatches-full" id="buildfuly-color-swatches-full" style="display: none;">
							<div class="buildfuly-color-swatch">
								<input type="color" class="buildfuly-color-picker" id="color-primary">
								<label for="color-primary" class="buildfuly-color-name">Primary</label>
							</div>
							<div class="buildfuly-color-swatch">
								<input type="color" class="buildfuly-color-picker" id="color-secondary">
								<label for="color-secondary" class="buildfuly-color-name">Secondary</label>
							</div>
							<div class="buildfuly-color-swatch">
								<input type="color" class="buildfuly-color-picker" id="color-text">
								<label for="color-text" class="buildfuly-color-name">Text (Dark)</label>
							</div>
							<div class="buildfuly-color-swatch">
								<input type="color" class="buildfuly-color-picker" id="color-text-light">
								<label for="color-text-light" class="buildfuly-color-name">Text (Light)</label>
							</div>
							<div class="buildfuly-color-swatch">
								<input type="color" class="buildfuly-color-picker" id="color-bg">
								<label for="color-bg" class="buildfuly-color-name">Background</label>
							</div>
							<button type="button" class="buildfuly-icon-btn buildfuly-icon-btn-white" id="buildfuly-regenerate-colors-icon" title="Generate New Colors">
								<span class="dashicons dashicons-update"></span>
							</button>
						</div>
					</div>
					<div style="display: flex; gap: 8px; align-items: center;">
						<button type="button" class="buildfuly-control-btn buildfuly-control-btn-small" id="buildfuly-batch-ai-images" style="background: linear-gradient(135deg, #667eea, #764ba2); border-color: #667eea; color: white;" title="Generate AI images for all sections">
							<span class="dashicons dashicons-art"></span>
							Batch AI Images
						</button>
						<button type="button" class="buildfuly-control-btn buildfuly-control-btn-small" id="buildfuly-upload-section-image" style="position: relative;">
							<span class="dashicons dashicons-format-image"></span>
							<span id="buildfuly-section-image-indicator" style="display: none; position: absolute; top: -4px; right: -4px; width: 12px; height: 12px; background: #10b981; border: 2px solid #fff; border-radius: 50%;"></span>
							Image
						</button>
						<select id="buildfuly-section-type" class="buildfuly-control-select buildfuly-control-select-small">
							<option value="random">Random Layout</option>
							<!-- Components loaded dynamically from API via JavaScript -->
						</select>
						<button class="buildfuly-control-btn buildfuly-control-btn-primary buildfuly-control-btn-small" id="buildfuly-add-section-from-keywords">
							<span class="dashicons dashicons-plus-alt"></span>
							Add Section
						</button>
						<button class="buildfuly-icon-btn buildfuly-btn-regenerate-refresh" id="buildfuly-regenerate-with-keywords" title="Regenerate Content">
							<span class="dashicons dashicons-update"></span>
						</button>
					</div>
				</div>
				<input type="hidden" id="buildfuly-section-image-id" value="">

			<!-- SEO Panel -->
				<div class="buildfuly-keywords-panel" id="buildfuly-keywords-panel" style="display: none;">
				<div class="buildfuly-keywords-subheader">
					<div style="display: flex; align-items: center; gap: 12px; flex: 1;">
						<div style="display: flex; align-items: center; gap: 8px; cursor: pointer;" id="buildfuly-keywords-toggle">
							<span class="dashicons dashicons-arrow-down-alt2" id="buildfuly-keywords-arrow"></span>
							<h3 style="margin: 0; display: flex; align-items: center; gap: 8px; font-size: 14px; font-weight: 600;">
								<span class="dashicons dashicons-chart-line"></span>
								SEO
							</h3>
						</div>
						<button class="buildfuly-keyword-add-btn" id="buildfuly-add-keyword" title="Add Keyword">
							<span class="dashicons dashicons-plus-alt"></span>
						</button>
						<span id="buildfuly-keywords-preview" style="color: #6b7280; font-size: 13px; font-weight: 400; overflow: hidden; text-overflow: ellipsis; white-space: nowrap; display: none;"></span>
						<button id="buildfuly-open-seo-modal" class="buildfuly-control-btn buildfuly-control-btn-small" style="margin-left: auto;">
							<span class="dashicons dashicons-admin-settings"></span>
							SEO Metadata
						</button>
					</div>
				</div>
				<div class="buildfuly-keywords-list" id="buildfuly-keywords-list">
						<!-- Keywords will be dynamically added here -->
					</div>
				</div>

			<!-- SEO Metadata Modal -->
			<div id="buildfuly-seo-modal" class="buildfuly-modal" style="display: none;">
				<div class="buildfuly-modal-content" style="max-width: 900px;">
					<div class="buildfuly-modal-header">
						<h2>SEO Metadata <span id="buildfuly-seo-page-name" style="font-weight: 400; color: #6b7280;"></span></h2>
						<button class="buildfuly-modal-close" id="buildfuly-close-seo-modal">&times;</button>
					</div>
					<div class="buildfuly-modal-body">
						<div id="buildfuly-seo-not-published" style="display: none; background: #fef3c7; border: 1px solid #f59e0b; border-radius: 8px; padding: 16px; margin-bottom: 16px;">
							<strong>⚠️ Page Not Published</strong><br>
							<span style="font-size: 13px;">Publish this page first to edit its SEO metadata.</span>
						</div>
						<input type="hidden" id="buildfuly-seo-page-id" value="">
						
						<!-- Two Column Layout -->
						<div style="display: grid; grid-template-columns: 1fr 1fr; gap: 24px;">
							<!-- Left: Google Preview -->
							<div>
								<div class="buildfuly-google-preview">
									<div style="font-size: 11px; color: #9ca3af; margin-bottom: 8px; font-weight: 600; text-transform: uppercase;">Google Preview</div>
									<div class="buildfuly-google-preview-url" id="buildfuly-google-preview-url">yourdomain.com</div>
									<div class="buildfuly-google-preview-title" id="buildfuly-google-preview-title">Page Title • Brand</div>
									<div class="buildfuly-google-preview-desc" id="buildfuly-google-preview-desc">Meta description will appear here...</div>
								</div>
							</div>

							<!-- Right: SEO Fields -->
							<div>
								<div class="buildfuly-form-group" style="margin-bottom: 16px;">
									<label for="buildfuly-seo-slug" style="font-size: 13px; font-weight: 600; color: #374151; margin-bottom: 6px; display: block;">URL Slug</label>
									<input type="text" id="buildfuly-seo-slug" class="buildfuly-control-input" placeholder="page-url-slug">
									<p class="description" style="font-size: 12px; margin-top: 4px;">For homepage use: /</p>
								</div>
								<div class="buildfuly-form-group" style="margin-bottom: 16px;">
									<label for="buildfuly-seo-title" style="font-size: 13px; font-weight: 600; color: #374151; margin-bottom: 6px; display: block;">
										SEO Title <span class="char-count" id="buildfuly-seo-title-count">0/60</span>
									</label>
									<input type="text" id="buildfuly-seo-title" class="buildfuly-control-input" placeholder="Optimized page title" maxlength="60">
								</div>
								<div class="buildfuly-form-group" style="margin-bottom: 16px;">
									<label for="buildfuly-seo-description" style="font-size: 13px; font-weight: 600; color: #374151; margin-bottom: 6px; display: block;">
										Meta Description <span class="char-count" id="buildfuly-seo-desc-count">0/160</span>
									</label>
									<textarea id="buildfuly-seo-description" class="buildfuly-control-input" rows="3" placeholder="Brief description for search results" maxlength="160" style="resize: vertical;"></textarea>
								</div>
								<div class="buildfuly-form-group">
									<label for="buildfuly-seo-focus" style="font-size: 13px; font-weight: 600; color: #374151; margin-bottom: 6px; display: block;">Focus Keyphrase</label>
									<input type="text" id="buildfuly-seo-focus" class="buildfuly-control-input" placeholder="main keyword">
								</div>
							</div>
						</div>
					</div>
					<div class="buildfuly-modal-footer">
						<button class="button button-secondary" id="buildfuly-cancel-seo">Cancel</button>
						<button class="button button-primary" id="buildfuly-save-seo">
							<span class="dashicons dashicons-saved"></span>
							Save SEO & Update Page
						</button>
					</div>
				</div>
			</div>

			<!-- Control Bar -->
			
				<div class="buildfuly-control-group">
				<!-- Section type picker moved to keyword cards -->
				<?php /* 
				<select id="section-type" class="buildfuly-control-select">
						<?php
						// Auto-discover components and organize by type
						require_once plugin_dir_path( dirname( dirname( __FILE__ ) ) ) . 'includes/class-buildfuly-component-loader.php';
						$component_loader = new Buildfuly_Component_Loader();
						$components_by_type = $component_loader->get_components_by_type();
						
						// Display Hero components
						if ( ! empty( $components_by_type['hero'] ) ) {
							echo '<optgroup label="Hero Sections">';
							foreach ( $components_by_type['hero'] as $slug => $component ) {
								// Skip CTAs from hero group (they'll be in their own section)
								if ( strpos( $slug, 'cta' ) === 0 ) {
									continue;
								}
								printf(
									'<option value="%s">%s</option>',
									esc_attr( $slug ),
									esc_html( $component['name'] )
								);
							}
							echo '</optgroup>';
						}
						
						// Display Content components
						if ( ! empty( $components_by_type['content'] ) ) {
							echo '<optgroup label="Content Sections">';
							foreach ( $components_by_type['content'] as $slug => $component ) {
								printf(
									'<option value="%s">%s</option>',
									esc_attr( $slug ),
									esc_html( $component['name'] )
								);
							}
							echo '</optgroup>';
						}
						
						// Display CTA components
						if ( ! empty( $components_by_type['cta'] ) ) {
							echo '<optgroup label="Call to Actions">';
							foreach ( $components_by_type['cta'] as $slug => $component ) {
								printf(
									'<option value="%s">%s</option>',
									esc_attr( $slug ),
									esc_html( $component['name'] )
								);
							}
							echo '</optgroup>';
						}
						
						// Display Form components
						if ( ! empty( $components_by_type['form'] ) ) {
							echo '<optgroup label="Forms">';
							foreach ( $components_by_type['form'] as $slug => $component ) {
								printf(
									'<option value="%s">%s</option>',
									esc_attr( $slug ),
									esc_html( $component['name'] )
								);
							}
							echo '</optgroup>';
						}
						?>
					</select>
					<button class="buildfuly-control-btn buildfuly-control-btn-primary" id="buildfuly-add-section">
						<span class="dashicons dashicons-plus-alt"></span>
						Add Section
					</button>
					*/ ?>
			
				</div>

				<!-- Main Preview -->
				<div class="buildfuly-main-preview buildfuly-desktop-preview">
					<!-- Floating Device Controls -->
					<div class="buildfuly-device-controls-floating">
						<button class="buildfuly-device-btn active" data-device="desktop"><span class="dashicons dashicons-desktop"></span></button>
						<button class="buildfuly-device-btn" data-device="tablet"><span class="dashicons dashicons-tablet"></span></button>
						<button class="buildfuly-device-btn" data-device="mobile"><span class="dashicons dashicons-smartphone"></span></button>
					</div>
					
					<div id="buildfuly-loading" class="buildfuly-loading-overlay" style="display: none;">
						<div class="buildfuly-loader"></div>
						<p>Generating SEO-optimized page...</p>
					</div>
					
					<div id="buildfuly-sections-container" class="buildfuly-sections-container buildfuly-preview-frame">
						<div class="buildfuly-welcome-screen">
							<div class="buildfuly-welcome-icon">
								<span class="dashicons dashicons-welcome-widgets-menus"></span>
							</div>
							<h2>Welcome to Buildfuly</h2>
							<p>Create SEO-optimized pages for your website with AI</p>
							<button class="button button-primary button-hero" id="buildfuly-get-started">
								<span class="dashicons dashicons-plus-alt"></span>
								Create Your First Page
							</button>
						</div>
					</div>

					<!-- Floating Actions -->
					<div class="buildfuly-floating-actions" style="display: none;">
						<button class="buildfuly-fab" id="buildfuly-preview-live" title="Preview Live Page">
							<span class="dashicons dashicons-visibility"></span>
						</button>
						<button class="buildfuly-fab" id="buildfuly-save-page" title="Save Page">
							<span class="dashicons dashicons-saved"></span>
						</button>
						<button class="buildfuly-fab buildfuly-fab-primary" id="buildfuly-publish-page" title="Publish Page">
							<span class="dashicons dashicons-yes-alt"></span>
						</button>
					</div>
				</div>
			</div>
		</div>
		
		<!-- Generate More Pages Modal -->
		<div id="buildfuly-suggest-pages-modal" class="buildfuly-modal" style="display: none;">
			<div class="buildfuly-modal-content" style="max-width: 600px;">
				<div class="buildfuly-modal-header">
					<h2>Generate More Pages</h2>
					<button class="buildfuly-modal-close" id="buildfuly-suggest-close">&times;</button>
				</div>
				<div class="buildfuly-modal-body">
					<!-- Configuration Form -->
					<div id="suggest-config-form">
						<div class="form-group" style="margin-bottom: 32px;">
							<label style="display: block; margin-bottom: 16px; font-size: 15px; font-weight: 600; color: #1d1d1f;">
								How many pages would you like?
							</label>
							
							<div style="display: flex; align-items: center; gap: 20px;">
								<input type="range" 
									   id="suggest-page-count" 
									   min="1" 
									   max="20" 
									   value="5"
									   style="flex: 1; height: 6px; border-radius: 3px; background: linear-gradient(to right, #0071e3 0%, #0071e3 25%, #e5e7eb 25%, #e5e7eb 100%); outline: none; -webkit-appearance: none; appearance: none; cursor: pointer;">
								
								<div style="
									min-width: 80px;
									text-align: center;
									padding: 12px 20px;
									background: linear-gradient(135deg, #0071e3 0%, #0077ed 100%);
									color: white;
									border-radius: 12px;
									font-size: 24px;
									font-weight: 700;
									box-shadow: 0 4px 12px rgba(0, 113, 227, 0.25);
								">
									<span id="suggest-page-count-display">5</span>
								</div>
							</div>
							
							<div style="text-align: center; margin-top: 12px;">
								<p style="font-size: 13px; color: #0071e3; margin: 0; font-weight: 500;">
									💡 Uses <strong><span id="suggest-token-cost">~25</span> tokens</strong> to generate page ideas
								</p>
								<p style="font-size: 11px; color: #86868b; margin: 4px 0 0 0;">
									SEO keywords & content will use additional tokens when generated
								</p>
							</div>
						</div>
						
					<?php 
					$location = get_option('buildfuly_location', ''); // phpcs:ignore WordPress.NamingConventions.PrefixAllGlobals.NonPrefixedVariableFound
					$locationRelevant = get_option('buildfuly_location_relevant', false); // phpcs:ignore WordPress.NamingConventions.PrefixAllGlobals.NonPrefixedVariableFound
					if ($locationRelevant && $location): ?>
						<div class="form-group" style="
							margin-bottom: 20px;
							padding: 16px;
							background: linear-gradient(135deg, #f0f9ff 0%, #e0f2fe 100%);
							border-radius: 12px;
							border: 1px solid #bae6fd;
						">
							<label style="display: flex; align-items: center; gap: 10px; cursor: pointer;">
								<input type="checkbox" id="suggest-location-relevant" checked style="
									width: 20px;
									height: 20px;
									margin: 0;
									cursor: pointer;
									accent-color: #0071e3;
								">
								<div style="flex: 1;">
									<div style="font-size: 14px; font-weight: 600; color: #1d1d1f; margin-bottom: 4px;">
										📍 Include <strong><?php echo esc_html($location); ?></strong> in keywords
									</div>
									<div style="font-size: 12px; color: #0369a1;">
										Optimizes pages for local SEO and regional searches
									</div>
								</div>
							</label>
						</div>
						<?php endif; ?>
					</div>
					
					<!-- Loading state -->
					<div id="suggested-pages-loading" style="display: none;">
						<div class="page-suggestions-loading">
							<div class="spinner"></div>
							<p><strong id="suggest-generation-status">Analyzing your business...</strong></p>
							<p style="font-size: 14px; color: #6b7280; margin-top: 8px;" id="suggest-generation-substatus">Generating page ideas and SEO keywords</p>
							
							<!-- Live page suggestions appear here as they're generated -->
							<div id="suggest-live-suggestions" style="margin-top: 32px; display: none;">
								<div id="suggest-live-suggestions-header" style="font-size: 14px; font-weight: 600; color: #1d1d1f; margin-bottom: 16px; text-align: left; display: none;">
									<span style="color: #0071e3;">✨</span> AI Recommended Pages:
								</div>
								<div id="suggest-live-pages-grid" style="display: grid; grid-template-columns: repeat(auto-fit, minmax(180px, 1fr)); gap: 12px; text-align: left;">
									<!-- Pages appear here dynamically -->
								</div>
							</div>
						</div>
					</div>
					
					<!-- Page selection -->
					<div id="suggested-pages-selection" style="display: none;">
						<h3 style="margin-bottom: 16px; color: #1d1d1f;">Select pages to add:</h3>
						<div id="suggested-pages-grid" class="page-selection-grid">
							<!-- AI-suggested pages will appear here as checkboxes -->
						</div>
						<div class="page-count-info" style="margin-top: 16px;">
							<span id="suggest-page-count">0</span> pages selected
						</div>
					</div>
					
					<!-- Success message -->
					<div id="suggested-pages-success" style="display: none; text-align: center; padding: 40px 20px;">
						<div style="font-size: 48px; margin-bottom: 16px;">✅</div>
						<h3 style="margin-bottom: 8px;">Pages Added!</h3>
						<p style="color: #6b7280;">Your new pages have been added to the page manager.</p>
					</div>
				</div>
				<div class="buildfuly-modal-footer">
					<button class="button button-secondary" id="buildfuly-suggest-cancel">Cancel</button>
					<button class="button button-primary" id="buildfuly-suggest-generate">
						<span class="dashicons dashicons-admin-page"></span>
						Generate Pages
					</button>
					<button class="button button-primary" id="buildfuly-suggest-add" style="display: none;">
						<span class="dashicons dashicons-plus-alt"></span>
						Add Selected Pages
					</button>
				</div>
			</div>
		</div>

		<!-- New Blog Post Modal -->
		<div id="buildfuly-new-blog-modal" class="buildfuly-modal" style="display: none;">
			<div class="buildfuly-modal-content" style="max-width: 700px;">
				<div class="buildfuly-modal-header">
					<h2>Create New Blog Post</h2>
					<button class="buildfuly-modal-close" id="buildfuly-blog-modal-close">&times;</button>
				</div>
				<div class="buildfuly-modal-body">
					<!-- Step 1: Blog Topic -->
					<div id="buildfuly-blog-step-1">
						<div class="buildfuly-form-group">
							<label for="blog-topic">What do you want to write about?</label>
							<input type="text" id="blog-topic" class="buildfuly-control-input" placeholder="e.g., 10 Tips for Better SEO, How to Choose a Web Designer..." style="width: 100%; margin-bottom: 8px;">
							<p class="description">Describe your blog topic and we'll generate an outline with SEO keywords</p>
						</div>
						<div class="buildfuly-form-group" style="margin-top: 24px;">
							<button type="button" class="button button-primary" id="buildfuly-analyze-blog" style="width: 100%;">
								<span class="dashicons dashicons-analytics"></span>
								Generate Blog Outline
							</button>
						</div>
					</div>

					<!-- Step 2: Blog Customization -->
					<div id="buildfuly-blog-step-2" style="display: none;">
						<div class="buildfuly-form-group">
							<label for="blog-title-input">Blog Title</label>
							<input type="text" id="blog-title-input" class="buildfuly-control-input" placeholder="Your blog post title..." style="width: 100%;">
							<p class="description">This will be the title of your blog post</p>
						</div>
						<div class="buildfuly-form-group" style="margin-top: 16px;">
							<label for="blog-keywords">SEO Keywords</label>
							<input type="text" id="blog-keywords" class="buildfuly-control-input" placeholder="Keywords will be generated..." style="width: 100%;">
							<p class="description">Generated from your topic (you can edit these)</p>
						</div>

						<!-- Word Count Slider -->
						<div class="buildfuly-form-group" style="margin-top: 24px; padding: 20px; background: #f9fafb; border-radius: 8px; border: 1px solid #e5e7eb;">
							<h3 style="margin: 0 0 16px 0; font-size: 14px; font-weight: 600; display: flex; align-items: center; gap: 8px;">
								<span class="dashicons dashicons-editor-paragraph"></span>
								Blog Length
							</h3>

							<div style="margin-bottom: 20px;">
								<label for="buildfuly-blog-word-count" style="display: flex; justify-content: space-between; margin-bottom: 8px;">
									<span>Target Word Count</span>
									<span id="buildfuly-blog-word-count-label" style="font-weight: 600; color: #2563eb;">1200 words</span>
								</label>
								<input type="range" id="buildfuly-blog-word-count" min="600" max="3000" value="1200" step="100" style="width: 100%;">
								<div style="display: flex; justify-content: space-between; font-size: 11px; color: #6b7280; margin-top: 4px;">
									<span>Short (600)</span>
									<span>Medium (1200)</span>
									<span>Long (3000)</span>
								</div>
							</div>

							<!-- Blog Type Selection -->
							<div style="margin-bottom: 16px;">
								<label style="display: block; margin-bottom: 8px; font-weight: 500;">Blog Type</label>
								<div style="display: flex; gap: 8px; flex-wrap: wrap;">
									<label class="buildfuly-blog-type-option" style="display: flex; align-items: center; gap: 6px; padding: 8px 12px; background: white; border: 1px solid #e5e7eb; border-radius: 6px; cursor: pointer;">
										<input type="radio" name="blog-type" value="how-to" checked style="margin: 0;">
										<span>How-to Guide</span>
									</label>
									<label class="buildfuly-blog-type-option" style="display: flex; align-items: center; gap: 6px; padding: 8px 12px; background: white; border: 1px solid #e5e7eb; border-radius: 6px; cursor: pointer;">
										<input type="radio" name="blog-type" value="listicle" style="margin: 0;">
										<span>Listicle</span>
									</label>
									<label class="buildfuly-blog-type-option" style="display: flex; align-items: center; gap: 6px; padding: 8px 12px; background: white; border: 1px solid #e5e7eb; border-radius: 6px; cursor: pointer;">
										<input type="radio" name="blog-type" value="guide" style="margin: 0;">
										<span>In-depth Guide</span>
									</label>
									<label class="buildfuly-blog-type-option" style="display: flex; align-items: center; gap: 6px; padding: 8px 12px; background: white; border: 1px solid #e5e7eb; border-radius: 6px; cursor: pointer;">
										<input type="radio" name="blog-type" value="comparison" style="margin: 0;">
										<span>Comparison</span>
									</label>
								</div>
							</div>

							<!-- Word Estimation -->
							<div style="padding: 12px; background: #f0f9ff; border-radius: 4px; border-left: 3px solid #667eea;">
								<div style="display: flex; justify-content: space-between; align-items: center;">
									<span style="font-size: 13px; color: #374151;">Estimated Reading Time:</span>
									<span id="buildfuly-blog-reading-time" style="font-weight: 600; font-size: 14px; color: #667eea;">~5 min</span>
								</div>
							</div>
						</div>

						<!-- Featured Image -->
						<div class="buildfuly-form-group" style="margin-top: 24px; padding-top: 24px; border-top: 1px solid #e5e7eb;">
							<label>Featured Image (Optional)</label>
							<p class="description">Add a featured image for your blog post</p>
							<div id="buildfuly-blog-image-preview" style="margin: 16px 0;">
								<!-- Image preview will appear here -->
							</div>
							<button type="button" class="button button-secondary" id="buildfuly-upload-blog-image">
								<span class="dashicons dashicons-format-image" style="margin-top: 3px;"></span>
								Add Featured Image
							</button>
							<input type="hidden" id="buildfuly-blog-image-id" value="">
						</div>

						<div style="margin-top: 16px; text-align: center;">
							<button type="button" class="button button-link" id="buildfuly-back-to-blog-topic">
								← Back to Topic
							</button>
						</div>
					</div>
				</div>
				<div class="buildfuly-modal-footer">
					<button class="button button-secondary" id="buildfuly-cancel-blog">Cancel</button>
					<button class="button button-primary" id="buildfuly-create-blog" style="display: none;">
						<span class="dashicons dashicons-edit"></span>
						Generate Blog Post
					</button>
				</div>
			</div>
		</div>

		<!-- Generate Blog Ideas Modal -->
		<div id="buildfuly-suggest-blogs-modal" class="buildfuly-modal" style="display: none;">
			<div class="buildfuly-modal-content" style="max-width: 600px;">
				<div class="buildfuly-modal-header">
					<h2>Generate Blog Ideas</h2>
					<button class="buildfuly-modal-close" id="buildfuly-suggest-blogs-close">&times;</button>
				</div>
				<div class="buildfuly-modal-body">
					<!-- Configuration Form -->
					<div id="suggest-blogs-config-form">
						<div class="form-group" style="margin-bottom: 32px;">
							<label style="display: block; margin-bottom: 16px; font-size: 15px; font-weight: 600; color: #1d1d1f;">
								How many blog ideas would you like?
							</label>
							
							<div style="display: flex; align-items: center; gap: 20px;">
								<input type="range" 
									   id="suggest-blog-count" 
									   min="1" 
									   max="20" 
									   value="5"
									   style="flex: 1; height: 6px; border-radius: 3px; background: linear-gradient(to right, #10b981 0%, #10b981 25%, #e5e7eb 25%, #e5e7eb 100%); outline: none; -webkit-appearance: none; appearance: none; cursor: pointer;">
								
								<div style="
									min-width: 80px;
									text-align: center;
									padding: 12px 20px;
									background: linear-gradient(135deg, #10b981 0%, #059669 100%);
									color: white;
									border-radius: 12px;
									font-size: 24px;
									font-weight: 700;
									box-shadow: 0 4px 12px rgba(16, 185, 129, 0.25);
								">
									<span id="suggest-blog-count-display">5</span>
								</div>
							</div>
							
							<div style="text-align: center; margin-top: 12px;">
								<p style="font-size: 13px; color: #10b981; margin: 0; font-weight: 500;">
									💡 Uses <strong><span id="suggest-blog-token-cost">~25</span> tokens</strong> to generate blog ideas
								</p>
							</div>
						</div>
					</div>
					
					<!-- Loading state -->
					<div id="suggested-blogs-loading" style="display: none;">
						<div class="page-suggestions-loading">
							<div class="spinner"></div>
							<p><strong id="suggest-blog-generation-status">Analyzing your business...</strong></p>
							<p style="font-size: 14px; color: #6b7280; margin-top: 8px;">Generating blog topic ideas</p>
						</div>
					</div>
					
					<!-- Blog selection -->
					<div id="suggested-blogs-selection" style="display: none;">
						<h3 style="margin-bottom: 16px; color: #1d1d1f;">Select blog topics to add:</h3>
						<div id="suggested-blogs-grid" class="page-selection-grid">
							<!-- AI-suggested blogs will appear here as checkboxes -->
						</div>
						<div class="page-count-info" style="margin-top: 16px;">
							<span id="suggest-blogs-selected-count">0</span> topics selected
						</div>
					</div>
					
					<!-- Success message -->
					<div id="suggested-blogs-success" style="display: none; text-align: center; padding: 40px 20px;">
						<div style="font-size: 48px; margin-bottom: 16px;">✅</div>
						<h3 style="margin-bottom: 8px;">Blog Topics Added!</h3>
						<p style="color: #6b7280;">Your new blog topics have been added to the blog manager.</p>
					</div>
				</div>
				<div class="buildfuly-modal-footer">
					<button class="button button-secondary" id="buildfuly-suggest-blogs-cancel">Cancel</button>
					<button class="button button-primary" id="buildfuly-suggest-blogs-generate">
						<span class="dashicons dashicons-lightbulb"></span>
						Generate Ideas
					</button>
					<button class="button button-primary" id="buildfuly-suggest-blogs-add" style="display: none;">
						<span class="dashicons dashicons-plus-alt"></span>
						Add Selected Topics
					</button>
				</div>
			</div>
		</div>
	</div>
</div>