/**
 * Buildfuly Templates
 * Pre-made content templates for different business types
 */

const BuildfulyTemplates = {
	saas: {
		title: 'Transform Your Business with Modern Software',
		subtitle: 'The all-in-one platform that helps teams collaborate, automate workflows, and scale faster than ever before.',
		hero: `<div class="buildfuly-hero">
			<h1>Transform Your Business with Modern Software</h1>
			<p>The all-in-one platform that helps teams collaborate, automate workflows, and scale faster than ever before.</p>
			<a href="#" class="buildfuly-cta">Start Free Trial</a>
		</div>`,
		features: `<h2>Powerful Features, Simple Interface</h2>
		<p>Everything you need to run your business efficiently, all in one place.</p>`,
		cta: 'Start Free Trial'
	},
	
	agency: {
		title: 'Creative Solutions for Bold Brands',
		subtitle: 'We craft exceptional digital experiences that help brands stand out and connect with their audience.',
		hero: `<div class="buildfuly-hero">
			<h1>Creative Solutions for Bold Brands</h1>
			<p>We craft exceptional digital experiences that help brands stand out and connect with their audience.</p>
			<a href="#" class="buildfuly-cta">View Our Work</a>
		</div>`,
		features: `<h2>What We Do</h2>
		<p>From strategy to execution, we bring your vision to life with creativity and precision.</p>`,
		cta: 'View Our Work'
	},
	
	consulting: {
		title: 'Strategic Guidance for Growth',
		subtitle: 'Expert consulting services that help businesses navigate challenges and unlock new opportunities.',
		hero: `<div class="buildfuly-hero">
			<h1>Strategic Guidance for Growth</h1>
			<p>Expert consulting services that help businesses navigate challenges and unlock new opportunities.</p>
			<a href="#" class="buildfuly-cta">Schedule Consultation</a>
		</div>`,
		features: `<h2>Our Expertise</h2>
		<p>Decades of experience helping organizations achieve their most ambitious goals.</p>`,
		cta: 'Schedule Consultation'
	},
	
	ecommerce: {
		title: 'Shop the Latest Collection',
		subtitle: 'Discover premium products curated just for you. Free shipping on orders over $50.',
		hero: `<div class="buildfuly-hero">
			<h1>Shop the Latest Collection</h1>
			<p>Discover premium products curated just for you. Free shipping on orders over $50.</p>
			<a href="#" class="buildfuly-cta">Shop Now</a>
		</div>`,
		features: `<h2>Why Shop With Us</h2>
		<p>Quality products, fast shipping, and exceptional customer service every time.</p>`,
		cta: 'Shop Now'
	},
	
	portfolio: {
		title: 'Designer & Developer',
		subtitle: 'Creating beautiful, functional digital experiences with clean code and thoughtful design.',
		hero: `<div class="buildfuly-hero">
			<h1>Designer & Developer</h1>
			<p>Creating beautiful, functional digital experiences with clean code and thoughtful design.</p>
			<a href="#" class="buildfuly-cta">View Projects</a>
		</div>`,
		features: `<h2>Recent Work</h2>
		<p>A selection of projects that showcase my approach to design and development.</p>`,
		cta: 'View Projects'
	},
	
	restaurant: {
		title: 'Fresh Ingredients, Bold Flavors',
		subtitle: 'Experience culinary excellence with locally-sourced ingredients and innovative recipes.',
		hero: `<div class="buildfuly-hero">
			<h1>Fresh Ingredients, Bold Flavors</h1>
			<p>Experience culinary excellence with locally-sourced ingredients and innovative recipes.</p>
			<a href="#" class="buildfuly-cta">View Menu</a>
		</div>`,
		features: `<h2>Our Philosophy</h2>
		<p>We believe great food starts with great ingredients and passionate preparation.</p>`,
		cta: 'View Menu'
	},
	
	fitness: {
		title: 'Your Journey to Better Health Starts Here',
		subtitle: 'Personal training, group classes, and nutrition coaching designed to help you reach your goals.',
		hero: `<div class="buildfuly-hero">
			<h1>Your Journey to Better Health Starts Here</h1>
			<p>Personal training, group classes, and nutrition coaching designed to help you reach your goals.</p>
			<a href="#" class="buildfuly-cta">Get Started</a>
		</div>`,
		features: `<h2>Programs & Services</h2>
		<p>Comprehensive fitness solutions tailored to your unique needs and lifestyle.</p>`,
		cta: 'Get Started'
	},
	
	tech: {
		title: 'Building the Future of Technology',
		subtitle: 'Innovative solutions powered by cutting-edge AI and machine learning.',
		hero: `<div class="buildfuly-hero">
			<h1>Building the Future of Technology</h1>
			<p>Innovative solutions powered by cutting-edge AI and machine learning.</p>
			<a href="#" class="buildfuly-cta">Learn More</a>
		</div>`,
		features: `<h2>Our Technology</h2>
		<p>Advanced algorithms and infrastructure built for scale and performance.</p>`,
		cta: 'Learn More'
	}
};

// Make available globally
window.BuildfulyTemplates = BuildfulyTemplates;
